//
//  MCReplicaConflictCandidate.h
//  MCClientServer
//
//  Created by Alykhan Jetha on 2013-07-22.
//
//

#import <Foundation/Foundation.h>
#import "MCClientServerDefines.h"

/*!
 An object used to represent a potential conflict during sync that may require some action.
 */

@interface MCReplicaConflictCandidate : NSObject
{
    NSUInteger tableID;
    NSUInteger rowID;
    NSSet *fields;
    MCSReplicaConflictType conflictType;
    NSDictionary *localRow;
    NSDictionary *localChangeSet;
    NSDictionary *remoteRow;
    NSDictionary *remoteChangeSet;
    NSString *resetCachedValuesSQL;
}

@property NSUInteger tableID;
@property NSUInteger rowID;
@property (retain) NSSet *fields;
@property MCSReplicaConflictType conflictType;
@property (retain) NSDictionary *localRow;
@property (retain) NSDictionary *localChangeSet;
@property (retain) NSDictionary *remoteRow;
@property (retain) NSDictionary *remoteChangeSet;
@property (retain) NSString *resetCachedValuesSQL;

+ (MCReplicaConflictCandidate *)basicCachedValueConflictForChange:(NSDictionary *)change;
+ (MCReplicaConflictCandidate *)basicCheckpointConflictForChange:(NSDictionary *)change;


@end
